﻿using System;

namespace Net.Sf.Pkcs11.Wrapper
{

	public enum CKM:uint
	{
		RSA_PKCS_KEY_PAIR_GEN = PKCS11Constants.CKM_RSA_PKCS_KEY_PAIR_GEN,
		RSA_PKCS = PKCS11Constants.CKM_RSA_PKCS,
		RSA_9796 = PKCS11Constants.CKM_RSA_9796,
		RSA_X_509 = PKCS11Constants.CKM_RSA_X_509,
		MD2_RSA_PKCS = PKCS11Constants.CKM_MD2_RSA_PKCS,
		MD5_RSA_PKCS = PKCS11Constants.CKM_MD5_RSA_PKCS,
		SHA1_RSA_PKCS = PKCS11Constants.CKM_SHA1_RSA_PKCS,
		RIPEMD128_RSA_PKCS = PKCS11Constants.CKM_RIPEMD128_RSA_PKCS,
		RIPEMD160_RSA_PKCS = PKCS11Constants.CKM_RIPEMD160_RSA_PKCS,
		RSA_PKCS_OAEP = PKCS11Constants.CKM_RSA_PKCS_OAEP,
		RSA_X9_31_KEY_PAIR_GEN = PKCS11Constants.CKM_RSA_X9_31_KEY_PAIR_GEN,
		RSA_X9_31 = PKCS11Constants.CKM_RSA_X9_31,
		SHA1_RSA_X9_31 = PKCS11Constants.CKM_SHA1_RSA_X9_31,
		RSA_PKCS_PSS = PKCS11Constants.CKM_RSA_PKCS_PSS,
		SHA1_RSA_PKCS_PSS = PKCS11Constants.CKM_SHA1_RSA_PKCS_PSS,
		DSA_KEY_PAIR_GEN = PKCS11Constants.CKM_DSA_KEY_PAIR_GEN,
		DSA = PKCS11Constants.CKM_DSA,
		DSA_SHA1 = PKCS11Constants.CKM_DSA_SHA1,
		DH_PKCS_KEY_PAIR_GEN = PKCS11Constants.CKM_DH_PKCS_KEY_PAIR_GEN,
		DH_PKCS_DERIVE = PKCS11Constants.CKM_DH_PKCS_DERIVE,
		X9_42_DH_KEY_PAIR_GEN = PKCS11Constants.CKM_X9_42_DH_KEY_PAIR_GEN,
		X9_42_DH_DERIVE = PKCS11Constants.CKM_X9_42_DH_DERIVE,
		X9_42_DH_HYBRID_DERIVE = PKCS11Constants.CKM_X9_42_DH_HYBRID_DERIVE,
		X9_42_MQV_DERIVE = PKCS11Constants.CKM_X9_42_MQV_DERIVE,
		SHA256_RSA_PKCS = PKCS11Constants.CKM_SHA256_RSA_PKCS,
		SHA384_RSA_PKCS = PKCS11Constants.CKM_SHA384_RSA_PKCS,
		SHA512_RSA_PKCS = PKCS11Constants.CKM_SHA512_RSA_PKCS,
		SHA256_RSA_PKCS_PSS = PKCS11Constants.CKM_SHA256_RSA_PKCS_PSS,
		SHA384_RSA_PKCS_PSS = PKCS11Constants.CKM_SHA384_RSA_PKCS_PSS,
		SHA512_RSA_PKCS_PSS = PKCS11Constants.CKM_SHA512_RSA_PKCS_PSS,
		RC2_KEY_GEN = PKCS11Constants.CKM_RC2_KEY_GEN,
		RC2_ECB = PKCS11Constants.CKM_RC2_ECB,
		RC2_CBC = PKCS11Constants.CKM_RC2_CBC,
		RC2_MAC = PKCS11Constants.CKM_RC2_MAC,
		RC2_MAC_GENERAL = PKCS11Constants.CKM_RC2_MAC_GENERAL,
		RC2_CBC_PAD = PKCS11Constants.CKM_RC2_CBC_PAD,
		RC4_KEY_GEN = PKCS11Constants.CKM_RC4_KEY_GEN,
		RC4 = PKCS11Constants.CKM_RC4,
		DES_KEY_GEN = PKCS11Constants.CKM_DES_KEY_GEN,
		DES_ECB = PKCS11Constants.CKM_DES_ECB,
		DES_CBC = PKCS11Constants.CKM_DES_CBC,
		DES_MAC = PKCS11Constants.CKM_DES_MAC,
		DES_MAC_GENERAL = PKCS11Constants.CKM_DES_MAC_GENERAL,
		DES_CBC_PAD = PKCS11Constants.CKM_DES_CBC_PAD,
		DES2_KEY_GEN = PKCS11Constants.CKM_DES2_KEY_GEN,
		DES3_KEY_GEN = PKCS11Constants.CKM_DES3_KEY_GEN,
		DES3_ECB = PKCS11Constants.CKM_DES3_ECB,
		DES3_CBC = PKCS11Constants.CKM_DES3_CBC,
		DES3_MAC = PKCS11Constants.CKM_DES3_MAC,
		DES3_MAC_GENERAL = PKCS11Constants.CKM_DES3_MAC_GENERAL,
		DES3_CBC_PAD = PKCS11Constants.CKM_DES3_CBC_PAD,
		CDMF_KEY_GEN = PKCS11Constants.CKM_CDMF_KEY_GEN,
		CDMF_ECB = PKCS11Constants.CKM_CDMF_ECB,
		CDMF_CBC = PKCS11Constants.CKM_CDMF_CBC,
		CDMF_MAC = PKCS11Constants.CKM_CDMF_MAC,
		CDMF_MAC_GENERAL = PKCS11Constants.CKM_CDMF_MAC_GENERAL,
		CDMF_CBC_PAD = PKCS11Constants.CKM_CDMF_CBC_PAD,
		DES_OFB64 = PKCS11Constants.CKM_DES_OFB64,
		DES_OFB8 = PKCS11Constants.CKM_DES_OFB8,
		DES_CFB64 = PKCS11Constants.CKM_DES_CFB64,
		DES_CFB8 = PKCS11Constants.CKM_DES_CFB8,
		MD2 = PKCS11Constants.CKM_MD2,
		MD2_HMAC = PKCS11Constants.CKM_MD2_HMAC,
		MD2_HMAC_GENERAL = PKCS11Constants.CKM_MD2_HMAC_GENERAL,
		MD5 = PKCS11Constants.CKM_MD5,
		MD5_HMAC = PKCS11Constants.CKM_MD5_HMAC,
		MD5_HMAC_GENERAL = PKCS11Constants.CKM_MD5_HMAC_GENERAL,
		SHA_1 = PKCS11Constants.CKM_SHA_1,
		SHA_1_HMAC = PKCS11Constants.CKM_SHA_1_HMAC,
		SHA_1_HMAC_GENERAL = PKCS11Constants.CKM_SHA_1_HMAC_GENERAL,
		RIPEMD128 = PKCS11Constants.CKM_RIPEMD128,
		RIPEMD128_HMAC = PKCS11Constants.CKM_RIPEMD128_HMAC,
		RIPEMD128_HMAC_GENERAL = PKCS11Constants.CKM_RIPEMD128_HMAC_GENERAL,
		RIPEMD160 = PKCS11Constants.CKM_RIPEMD160,
		RIPEMD160_HMAC = PKCS11Constants.CKM_RIPEMD160_HMAC,
		RIPEMD160_HMAC_GENERAL = PKCS11Constants.CKM_RIPEMD160_HMAC_GENERAL,
		SHA256 = PKCS11Constants.CKM_SHA256,
		SHA256_HMAC = PKCS11Constants.CKM_SHA256_HMAC,
		SHA256_HMAC_GENERAL = PKCS11Constants.CKM_SHA256_HMAC_GENERAL,
		SHA384 = PKCS11Constants.CKM_SHA384,
		SHA384_HMAC = PKCS11Constants.CKM_SHA384_HMAC,
		SHA384_HMAC_GENERAL = PKCS11Constants.CKM_SHA384_HMAC_GENERAL,
		SHA512 = PKCS11Constants.CKM_SHA512,
		SHA512_HMAC = PKCS11Constants.CKM_SHA512_HMAC,
		SHA512_HMAC_GENERAL = PKCS11Constants.CKM_SHA512_HMAC_GENERAL,
		CAST_KEY_GEN = PKCS11Constants.CKM_CAST_KEY_GEN,
		CAST_ECB = PKCS11Constants.CKM_CAST_ECB,
		CAST_CBC = PKCS11Constants.CKM_CAST_CBC,
		CAST_MAC = PKCS11Constants.CKM_CAST_MAC,
		CAST_MAC_GENERAL = PKCS11Constants.CKM_CAST_MAC_GENERAL,
		CAST_CBC_PAD = PKCS11Constants.CKM_CAST_CBC_PAD,
		CAST3_KEY_GEN = PKCS11Constants.CKM_CAST3_KEY_GEN,
		CAST3_ECB = PKCS11Constants.CKM_CAST3_ECB,
		CAST3_CBC = PKCS11Constants.CKM_CAST3_CBC,
		CAST3_MAC = PKCS11Constants.CKM_CAST3_MAC,
		CAST3_MAC_GENERAL = PKCS11Constants.CKM_CAST3_MAC_GENERAL,
		CAST3_CBC_PAD = PKCS11Constants.CKM_CAST3_CBC_PAD,
		CAST5_KEY_GEN = PKCS11Constants.CKM_CAST5_KEY_GEN,
		CAST128_KEY_GEN = PKCS11Constants.CKM_CAST128_KEY_GEN,
		CAST128_ECB = PKCS11Constants.CKM_CAST128_ECB,
		CAST5_ECB = PKCS11Constants.CKM_CAST5_ECB,
		CAST5_CBC = PKCS11Constants.CKM_CAST5_CBC,
		CAST128_CBC = PKCS11Constants.CKM_CAST128_CBC,
		CAST128_MAC = PKCS11Constants.CKM_CAST128_MAC,
		CAST5_MAC = PKCS11Constants.CKM_CAST5_MAC,
		CAST5_MAC_GENERAL = PKCS11Constants.CKM_CAST5_MAC_GENERAL,
		CAST128_MAC_GENERAL = PKCS11Constants.CKM_CAST128_MAC_GENERAL,
		CAST128_CBC_PAD = PKCS11Constants.CKM_CAST128_CBC_PAD,
		CAST5_CBC_PAD = PKCS11Constants.CKM_CAST5_CBC_PAD,
		RC5_KEY_GEN = PKCS11Constants.CKM_RC5_KEY_GEN,
		RC5_ECB = PKCS11Constants.CKM_RC5_ECB,
		RC5_CBC = PKCS11Constants.CKM_RC5_CBC,
		RC5_MAC = PKCS11Constants.CKM_RC5_MAC,
		RC5_MAC_GENERAL = PKCS11Constants.CKM_RC5_MAC_GENERAL,
		RC5_CBC_PAD = PKCS11Constants.CKM_RC5_CBC_PAD,
		IDEA_KEY_GEN = PKCS11Constants.CKM_IDEA_KEY_GEN,
		IDEA_ECB = PKCS11Constants.CKM_IDEA_ECB,
		IDEA_CBC = PKCS11Constants.CKM_IDEA_CBC,
		IDEA_MAC = PKCS11Constants.CKM_IDEA_MAC,
		IDEA_MAC_GENERAL = PKCS11Constants.CKM_IDEA_MAC_GENERAL,
		IDEA_CBC_PAD = PKCS11Constants.CKM_IDEA_CBC_PAD,
		GENERIC_SECRET_KEY_GEN = PKCS11Constants.CKM_GENERIC_SECRET_KEY_GEN,
		CONCATENATE_BASE_AND_KEY = PKCS11Constants.CKM_CONCATENATE_BASE_AND_KEY,
		CONCATENATE_BASE_AND_DATA = PKCS11Constants.CKM_CONCATENATE_BASE_AND_DATA,
		CONCATENATE_DATA_AND_BASE = PKCS11Constants.CKM_CONCATENATE_DATA_AND_BASE,
		XOR_BASE_AND_DATA = PKCS11Constants.CKM_XOR_BASE_AND_DATA,
		EXTRACT_KEY_FROM_KEY = PKCS11Constants.CKM_EXTRACT_KEY_FROM_KEY,
		SSL3_PRE_MASTER_KEY_GEN = PKCS11Constants.CKM_SSL3_PRE_MASTER_KEY_GEN,
		SSL3_MASTER_KEY_DERIVE = PKCS11Constants.CKM_SSL3_MASTER_KEY_DERIVE,
		SSL3_KEY_AND_MAC_DERIVE = PKCS11Constants.CKM_SSL3_KEY_AND_MAC_DERIVE,
		SSL3_MASTER_KEY_DERIVE_DH = PKCS11Constants.CKM_SSL3_MASTER_KEY_DERIVE_DH,
		TLS_PRE_MASTER_KEY_GEN = PKCS11Constants.CKM_TLS_PRE_MASTER_KEY_GEN,
		TLS_MASTER_KEY_DERIVE = PKCS11Constants.CKM_TLS_MASTER_KEY_DERIVE,
		TLS_KEY_AND_MAC_DERIVE = PKCS11Constants.CKM_TLS_KEY_AND_MAC_DERIVE,
		TLS_MASTER_KEY_DERIVE_DH = PKCS11Constants.CKM_TLS_MASTER_KEY_DERIVE_DH,
		TLS_PRF = PKCS11Constants.CKM_TLS_PRF,
		SSL3_MD5_MAC = PKCS11Constants.CKM_SSL3_MD5_MAC,
		SSL3_SHA1_MAC = PKCS11Constants.CKM_SSL3_SHA1_MAC,
		MD5_KEY_DERIVATION = PKCS11Constants.CKM_MD5_KEY_DERIVATION,
		MD2_KEY_DERIVATION = PKCS11Constants.CKM_MD2_KEY_DERIVATION,
		SHA1_KEY_DERIVATION = PKCS11Constants.CKM_SHA1_KEY_DERIVATION,
		SHA256_KEY_DERIVATION = PKCS11Constants.CKM_SHA256_KEY_DERIVATION,
		SHA384_KEY_DERIVATION = PKCS11Constants.CKM_SHA384_KEY_DERIVATION,
		SHA512_KEY_DERIVATION = PKCS11Constants.CKM_SHA512_KEY_DERIVATION,
		PBE_MD2_DES_CBC = PKCS11Constants.CKM_PBE_MD2_DES_CBC,
		PBE_MD5_DES_CBC = PKCS11Constants.CKM_PBE_MD5_DES_CBC,
		PBE_MD5_CAST_CBC = PKCS11Constants.CKM_PBE_MD5_CAST_CBC,
		PBE_MD5_CAST3_CBC = PKCS11Constants.CKM_PBE_MD5_CAST3_CBC,
		PBE_MD5_CAST5_CBC = PKCS11Constants.CKM_PBE_MD5_CAST5_CBC,
		PBE_MD5_CAST128_CBC = PKCS11Constants.CKM_PBE_MD5_CAST128_CBC,
		PBE_SHA1_CAST128_CBC = PKCS11Constants.CKM_PBE_SHA1_CAST128_CBC,
		PBE_SHA1_CAST5_CBC = PKCS11Constants.CKM_PBE_SHA1_CAST5_CBC,
		PBE_SHA1_RC4_128 = PKCS11Constants.CKM_PBE_SHA1_RC4_128,
		PBE_SHA1_RC4_40 = PKCS11Constants.CKM_PBE_SHA1_RC4_40,
		PBE_SHA1_DES3_EDE_CBC = PKCS11Constants.CKM_PBE_SHA1_DES3_EDE_CBC,
		PBE_SHA1_DES2_EDE_CBC = PKCS11Constants.CKM_PBE_SHA1_DES2_EDE_CBC,
		PBE_SHA1_RC2_128_CBC = PKCS11Constants.CKM_PBE_SHA1_RC2_128_CBC,
		PBE_SHA1_RC2_40_CBC = PKCS11Constants.CKM_PBE_SHA1_RC2_40_CBC,
		PKCS5_PBKD2 = PKCS11Constants.CKM_PKCS5_PBKD2,
		PBA_SHA1_WITH_SHA1_HMAC = PKCS11Constants.CKM_PBA_SHA1_WITH_SHA1_HMAC,
		WTLS_PRE_MASTER_KEY_GEN = PKCS11Constants.CKM_WTLS_PRE_MASTER_KEY_GEN,
		WTLS_MASTER_KEY_DERIVE = PKCS11Constants.CKM_WTLS_MASTER_KEY_DERIVE,
		WTLS_MASTER_KEY_DERVIE_DH_ECC = PKCS11Constants.CKM_WTLS_MASTER_KEY_DERVIE_DH_ECC,
		WTLS_PRF = PKCS11Constants.CKM_WTLS_PRF,
		WTLS_SERVER_KEY_AND_MAC_DERIVE = PKCS11Constants.CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE,
		WTLS_CLIENT_KEY_AND_MAC_DERIVE = PKCS11Constants.CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE,
		KEY_WRAP_LYNKS = PKCS11Constants.CKM_KEY_WRAP_LYNKS,
		KEY_WRAP_SET_OAEP = PKCS11Constants.CKM_KEY_WRAP_SET_OAEP,
		CMS_SIG = PKCS11Constants.CKM_CMS_SIG,
		SKIPJACK_KEY_GEN = PKCS11Constants.CKM_SKIPJACK_KEY_GEN,
		SKIPJACK_ECB64 = PKCS11Constants.CKM_SKIPJACK_ECB64,
		SKIPJACK_CBC64 = PKCS11Constants.CKM_SKIPJACK_CBC64,
		SKIPJACK_OFB64 = PKCS11Constants.CKM_SKIPJACK_OFB64,
		SKIPJACK_CFB64 = PKCS11Constants.CKM_SKIPJACK_CFB64,
		SKIPJACK_CFB32 = PKCS11Constants.CKM_SKIPJACK_CFB32,
		SKIPJACK_CFB16 = PKCS11Constants.CKM_SKIPJACK_CFB16,
		SKIPJACK_CFB8 = PKCS11Constants.CKM_SKIPJACK_CFB8,
		SKIPJACK_WRAP = PKCS11Constants.CKM_SKIPJACK_WRAP,
		SKIPJACK_PRIVATE_WRAP = PKCS11Constants.CKM_SKIPJACK_PRIVATE_WRAP,
		SKIPJACK_RELAYX = PKCS11Constants.CKM_SKIPJACK_RELAYX,
		KEA_KEY_PAIR_GEN = PKCS11Constants.CKM_KEA_KEY_PAIR_GEN,
		KEA_KEY_DERIVE = PKCS11Constants.CKM_KEA_KEY_DERIVE,
		FORTEZZA_TIMESTAMP = PKCS11Constants.CKM_FORTEZZA_TIMESTAMP,
		BATON_KEY_GEN = PKCS11Constants.CKM_BATON_KEY_GEN,
		BATON_ECB128 = PKCS11Constants.CKM_BATON_ECB128,
		BATON_ECB96 = PKCS11Constants.CKM_BATON_ECB96,
		BATON_CBC128 = PKCS11Constants.CKM_BATON_CBC128,
		BATON_COUNTER = PKCS11Constants.CKM_BATON_COUNTER,
		BATON_SHUFFLE = PKCS11Constants.CKM_BATON_SHUFFLE,
		BATON_WRAP = PKCS11Constants.CKM_BATON_WRAP,
		EC_KEY_PAIR_GEN = PKCS11Constants.CKM_EC_KEY_PAIR_GEN,
		ECDSA_KEY_PAIR_GEN = PKCS11Constants.CKM_ECDSA_KEY_PAIR_GEN,
		ECDSA = PKCS11Constants.CKM_ECDSA,
		ECDSA_SHA1 = PKCS11Constants.CKM_ECDSA_SHA1,
		ECDH1_DERIVE = PKCS11Constants.CKM_ECDH1_DERIVE,
		ECDH1_COFACTOR_DERIVE = PKCS11Constants.CKM_ECDH1_COFACTOR_DERIVE,
		ECMQV_DERIVE = PKCS11Constants.CKM_ECMQV_DERIVE,
		JUNIPER_KEY_GEN = PKCS11Constants.CKM_JUNIPER_KEY_GEN,
		JUNIPER_ECB128 = PKCS11Constants.CKM_JUNIPER_ECB128,
		JUNIPER_CBC128 = PKCS11Constants.CKM_JUNIPER_CBC128,
		JUNIPER_COUNTER = PKCS11Constants.CKM_JUNIPER_COUNTER,
		JUNIPER_SHUFFLE = PKCS11Constants.CKM_JUNIPER_SHUFFLE,
		JUNIPER_WRAP = PKCS11Constants.CKM_JUNIPER_WRAP,
		FASTHASH = PKCS11Constants.CKM_FASTHASH,
		AES_KEY_GEN = PKCS11Constants.CKM_AES_KEY_GEN,
		AES_ECB = PKCS11Constants.CKM_AES_ECB,
		AES_CBC = PKCS11Constants.CKM_AES_CBC,
		AES_MAC = PKCS11Constants.CKM_AES_MAC,
		AES_MAC_GENERAL = PKCS11Constants.CKM_AES_MAC_GENERAL,
		AES_CBC_PAD = PKCS11Constants.CKM_AES_CBC_PAD,
		BLOWFISH_KEY_GEN = PKCS11Constants.CKM_BLOWFISH_KEY_GEN,
		BLOWFISH_CBC = PKCS11Constants.CKM_BLOWFISH_CBC,
		TWOFISH_KEY_GEN = PKCS11Constants.CKM_TWOFISH_KEY_GEN,
		TWOFISH_CBC = PKCS11Constants.CKM_TWOFISH_CBC,
		DES_ECB_ENCRYPT_DATA = PKCS11Constants.CKM_DES_ECB_ENCRYPT_DATA,
		DES_CBC_ENCRYPT_DATA = PKCS11Constants.CKM_DES_CBC_ENCRYPT_DATA,
		DES3_ECB_ENCRYPT_DATA = PKCS11Constants.CKM_DES3_ECB_ENCRYPT_DATA,
		DES3_CBC_ENCRYPT_DATA = PKCS11Constants.CKM_DES3_CBC_ENCRYPT_DATA,
		AES_ECB_ENCRYPT_DATA = PKCS11Constants.CKM_AES_ECB_ENCRYPT_DATA,
		AES_CBC_ENCRYPT_DATA = PKCS11Constants.CKM_AES_CBC_ENCRYPT_DATA,
		DSA_PARAMETER_GEN = PKCS11Constants.CKM_DSA_PARAMETER_GEN,
		DH_PKCS_PARAMETER_GEN = PKCS11Constants.CKM_DH_PKCS_PARAMETER_GEN,
		X9_42_DH_PARAMETER_GEN = PKCS11Constants.CKM_X9_42_DH_PARAMETER_GEN,

        
        /// <summary>
        /// Механизм для генерации и проверки ЭЦП с использованием в качестве входа
        /// ранее вычисленного значения хэш-функции (32 байта ровно).
        /// </summary>
        GOSTR3410 = PKCS11Constants.CKM_GOSTR3410,

        /// <summary>
        /// Механизм для генерации ключевой пары.
        /// </summary>
        GOSTR3410_KEY_PAIR_GEN = PKCS11Constants.CKM_GOSTR3410_KEY_PAIR_GEN,
                
        /// <summary>
        /// Механизм для генерации и проверки ЭЦП с хэшированием подаваемых на вход данных.
        /// Размер входных данных не ограничен.
        /// </summary>
        GOSTR3410_WITH_GOSTR3411 = PKCS11Constants.CKM_GOSTR3410_WITH_GOSTR3411,
        
        /// <summary>
        /// Механизм для выработки ключа согласования.
        /// </summary>
        GOSTR3410_DERIVE = PKCS11Constants.CKM_GOSTR3410_DERIVE,

        /// <summary>
        /// Механизм вычисления хэш-функции.
        /// </summary>
        GOSTR3411 = PKCS11Constants.CKM_GOSTR3411,

        /// <summary>
        /// Механизм шифрования данных.
        /// </summary>
        GOST28147 = PKCS11Constants.CKM_GOST28147,

        /// <summary>
        /// Механизм шифрования данных с использованием метода простой замены.
        /// </summary>
        GOST28147_ECB = PKCS11Constants.CKM_GOST28147_ECB,

        /// <summary>
        /// Механизм экспорта и импорта открытых ключей.
        /// </summary>
        GOST28147_KEY_WRAP = PKCS11Constants.CKM_GOST28147_KEY_WRAP,

        /// <summary>
        /// Механизм выработки симметричных ключей.
        /// </summary>
        GOST28147_KEY_GEN = PKCS11Constants.CKM_GOST28147_KEY_GEN,

        /// <summary>
        /// Механизм для генерации ключевой пары согласно стандарту ГОСТ Р 34.10-2001.
        /// (From Etoken documentation, см. п.5.2. Параметры цифровой подписи).
        /// </summary>
        GOSTR3410_KEY_PAIR_GEN_EX  = PKCS11Constants.CKM_GOSTR3410_KEY_PAIR_GEN_EX,

		VENDOR_DEFINED = PKCS11Constants.CKM_VENDOR_DEFINED
	}
}
